package com.ejie.aa94a.model.calculo;

import java.io.Serializable;
import java.math.BigDecimal;

import com.ejie.aa94a.model.config.Densidad;
import com.ejie.aa94a.model.config.Posicion;

public class Bobina implements Serializable, Comparable<Bobina> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Posicion posicion;
	private Integer id;
	private Integer diametroExt;
	private Integer diametroInt;
	private Integer anchura;
	private BigDecimal peso;
	private Densidad densidad;

	/**
	 * 
	 */
	public Bobina() {
		super();
	}

	/**
	 * @param posicion
	 * @param diametroExt
	 * @param diametroInt
	 * @param anchura
	 * @param peso
	 * @param densidad
	 */
	public Bobina(Posicion posicion, Integer diametroExt, Integer diametroInt,
			Integer anchura, BigDecimal peso, Densidad densidad) {
		super();
		this.posicion = posicion;
		this.diametroExt = diametroExt;
		this.diametroInt = diametroInt;
		this.anchura = anchura;
		this.peso = peso;
		this.densidad = densidad;
	}

	/**
	 * @param diametroExt
	 * @param anchura
	 * @param peso
	 */
	public Bobina(Integer diametroExt, Integer anchura, BigDecimal peso) {
		super();
		this.diametroExt = diametroExt;
		this.anchura = anchura;
		this.peso = peso;
	}

	/**
	 * @return the diametroExt
	 */
	public Integer getDiametroExt() {
		return diametroExt;
	}

	/**
	 * @param diametroExt
	 *            the diametroExt to set
	 */
	public void setDiametroExt(Integer diametroExt) {
		this.diametroExt = diametroExt;
	}

	/**
	 * @return the diametroInt
	 */
	public Integer getDiametroInt() {
		return diametroInt;
	}

	/**
	 * @param diametroInt
	 *            the diametroInt to set
	 */
	public void setDiametroInt(Integer diametroInt) {
		this.diametroInt = diametroInt;
	}

	/**
	 * @return the anchura
	 */
	public Integer getAnchura() {
		return anchura;
	}

	/**
	 * @param anchura
	 *            the anchura to set
	 */
	public void setAnchura(Integer anchura) {
		this.anchura = anchura;
	}

	/**
	 * @return the peso
	 */
	public BigDecimal getPeso() {
		return peso;
	}

	/**
	 * @param peso
	 *            the peso to set
	 */
	public void setPeso(BigDecimal peso) {
		this.peso = peso;
	}

	/**
	 * @return the densidad
	 */
	public Densidad getDensidad() {
		return densidad;
	}

	/**
	 * @param densidad
	 *            the densidad to set
	 */
	public void setDensidad(Densidad densidad) {
		this.densidad = densidad;
	}

	/**
	 * @return the posicion
	 */
	public Posicion getPosicion() {
		return posicion;
	}

	/**
	 * 
	 * @return the identificador
	 */
	public String getIdentificador() {
		String identificador = null;
		if (this.getPosicion() != null) {
			identificador = this.getPosicion().getIdentificacion();
		}
		return identificador;

	}

	/**
	 * 
	 * @return the distancia
	 */
	public String getDistancia() {
		String distancia = null;
		if (this.getPosicion() != null
				&& this.getPosicion().getDistancia() != null) {
			distancia = this.getPosicion().getDistancia().toString();
		}
		return distancia;

	}

	@Override
	public int compareTo(Bobina arg0) {
		if (arg0 != null) {
			return arg0.peso.compareTo(this.peso);
		}
		return 0;
	}

	/**
	 * @param posicion
	 *            the posicion to set
	 */
	public void setPosicion(Posicion posicion) {
		this.posicion = posicion;
	}

	/**
	 * @return the id
	 */
	public Integer getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(Integer id) {
		this.id = id;
	}

}
